<?php

namespace Src\Domain\User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'email', 'password', 'phone', 'photoalbum_image_id', 'contact_id', 'description', 'awards', 'is_public', 'is_inactive');
    protected $hidden = array('timestamps');

    public function tags()
    {
        return $this->morphToMany('Src\Domain\User\User');
    }

    public function photoalbumImage()
    {
        return $this->belongsTo('Src\Domain\Documents\PhotoalbumImage');
    }

}